#############################################################################
# Modul pro implementace strategii
# --------------------------------------------------------
# Vasim ukolem je naimplementovat chytre (optimalni) strategie pro konkretni
# a obecnou variantu hry se sirkami (viz zadani). Doplte tedy vyznacene
# funkce vymysli_tah_konkretni() a vymysli_tah_obecna().
#
# Nize naleznete hotove implementaci hloupe strategie a strategie zastupujici
# cloveka (uzivatele), ktere muzete pouzit pri testovani te vasi
# (testujet spustenim run.py).
#
# Dulezite:
# Nepouzivejte globalni promenne a vsechen vas kod napiste dovnitr funkci
# vymysli_tah_konkreti() a vymysli_tah_obecna() (tj. zadny kod se nesmi objevit
# mimo vyznacene oblasti). Ve skutecnosti by mohlo byt pri opakovanem volani
# funkci casove efektivnejsi si treba neco predpocitat, ale pro jednoduchost
# ted budeme tuto moznost optimalizace ignorovat.
############################################################################


# knihovna pro praci s nahodnymi cisly
import random
# Knihovnu random neni nutne vyuzit, ale pokud byste presto chteli, tak se
# mrknete na jeji pouziti v ukazkove hloupe strategii nize.


# ----------------------------------------------------------------------------
#  Vase chytra strategie
# ----------------------------------------------------------------------------

# Vymysli jeden tah konkretni varianty hry
#  :param pocet_sirek: aktualni stav hry -- pocet zbyvajicich sirek
#  :return: pocet sirek, ktere chcete odebrat (1, 2 nebo 3)
def vymysli_tah_konkretni(pocet_sirek):
    if pocet_sirek%4 == 0:
        return 1 # prohral jsem - tak vezmi co nejmin sirek, abych zmatl lidskeho protihrace
    else:
        return pocet_sirek%4


# Vymysli jeden tah obecne varianty hry
#  :param pocet_sirek: aktualni stav hry -- pocet zbyvajicich sirek
#  :param povolene_tahy: seznam moznych tahu
#  :return: pocet sirek, ktere chcete odebrat
def vymysli_tah_obecna(pocet_sirek, povolene_tahy):
    ##### DOPLNTE ########################################################
    pass
    ######################################################################


# ----------------------------------------------------------------------------
#  Hloupa strategie
# ----------------------------------------------------------------------------

# hloupa strategie pro konkretni variantu hry
def vymysli_hloupy_tah_konkretni(pocet_sirek):
    # pokud muzeme vyhrat jednim tahem, tak to udelame
    if pocet_sirek <= 3:
        return pocet_sirek
    # jinak sebereme nahodny pocet sirek
    return random.randint(1, 3)


# hloupa strategie pro obecnou variantu hry
def vymysli_hloupy_tah_obecna(pocet_sirek, povolene_tahy):
    # pokud muzeme vyhrat jednim tahem, tak to udelame
    if pocet_sirek in povolene_tahy:
        return pocet_sirek
    # jinak zkusime vzit nahodny pocet sirek (z povolenych tahu),
    # coz ale nemusi byt mozne, pokud je na hromadce malo sirek
    # (v tom pripade vezmeme proste nejmensi povoleny pocet sirek)
    nahodny_pocet = random.choice(povolene_tahy)
    if nahodny_pocet <= pocet_sirek:
        return nahodny_pocet
    else:
        return min(povolene_tahy)


# ----------------------------------------------------------------------------
#  Strategie Clovek
# ----------------------------------------------------------------------------

# funkce pro strategii reprezentujici uzivatele (nezavisla na variante hry)
def vymysli_tah_clovek(pocet_sirek, povolene_tahy=None):
    odebrat_sirek = input('Kolik sirek odebrat: ')  # vstup uzivatele
    return odebrat_sirek
